#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Into You More! (Hearts)Mod01.fsh    by   dynamitedjs  
//https://www.shadertoy.com/view/ttsGzn
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Into You - by Martijn Steinrucken aka BigWings - 2018
// Email:countfrolic@gmail.com Twitter:@The_ArtOfCode
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// You can change the focal plane by moving the mouse up and down.

// A video of the effect can be found here:
// https://www.youtube.com/watch?v=lrMiME82Cuk

// Making of video part1:
// https://www.youtube.com/watch?v=dXyPOLf2MbU

// Android Phone Wallpaper:
// https://play.google.com/store/apps/details?id=com.TheArtOfCode.FallingHearts

// Music - Novo Amor - Anchor
// https://soundcloud.com/mrsuicidesheep/novo-amor-anchor


#define S(a, b, t) smoothstep(a, b, t)
#define sat(x) clamp(x, 0., 1.)
#define HEARTCOL vec3(1., .01, .01)
#define NUM_HEARTS 200.
#define LIGHT_DIR vec3(.577, -.577, -.577)

// Polynomial smooth max from IQ
float smax( float a, float b, float k ) {
	float h = sat( .5 + .5*(b-a)/k );
	return mix( a, b, h ) + k*h*(1.-h);
}

// Quaternion rotation functions from Ollj
vec4 qmulq(vec4 q1, vec4 q2){return vec4(q1.xyz*q2.w+q2.xyz*q1.w+cross(q1.xyz,q2.xyz),(q1.w*q2.w)-dot(q1.xyz,q2.xyz));}
vec4 aa2q(vec3 axis, float angle){return vec4(normalize(axis)*sin(angle*0.5),cos(angle*0.5));}
vec4 qinv(vec4 q){return vec4(-q.xyz,q.w)/dot(q,q);}
vec3 qmulv(vec4 q, vec3 p){return qmulq(q,qmulq(vec4(p,.0),qinv(q))).xyz;}

vec2 RaySphere(vec3 rd, vec3 p) {
    float l = dot(rd, p);
    float det = l*l - dot(p, p) + 1.;
    if (det < 0.) return vec2(-1);

    float sd = sqrt(det);
    return vec2(l - sd, l+sd);
}

struct sphereInfo {
	vec3 p1, p2, n1, n2;
    vec2 uv1, uv2;
};

sphereInfo GetSphereUvs(vec3 rd, vec2 i, vec2 rot, vec3 s) {
	sphereInfo res;
    rot *= 6.2831;
    vec4 q = aa2q(vec3(cos(rot.x),sin(rot.x),0), rot.y);
    vec3 o = qmulv(q, -s)+s;
    vec3 d = qmulv(q, rd);
    
    res.p1 = rd*i.x;
    vec3 p = o+d*i.x-s;
    res.uv1 = vec2(atan(p.x, p.z), p.y);
    res.n1 = res.p1-s;
    
    res.p2 = rd*i.y;
    p = o+d*i.y-s;
    res.uv2 = vec2(atan(p.x, p.z), p.y);
    res.n2 = s-res.p2;
        
    return res;
}

float Heart(vec2 uv, float b) {
	uv.x*=.5;
    float shape = smax(sqrt(abs(uv.x)), b, .3*b)*.5;
    uv.y -= shape*(1.-b);

    return S(b, -b, length(uv)-.5);
}

vec4 HeartBall(vec3 rd, vec3 p, vec2 rot, float t, float blur) {
    vec2 d = RaySphere(rd, p);
    
   	vec4 col = vec4(0);
    if(d.x>0.) {
    	sphereInfo info = GetSphereUvs(rd, d, rot, p);
    	
        float sd = length(cross(p, rd));
        float edge =  S(1., mix(1., 0.1, blur), sd);
        
        float backMask = Heart(info.uv2, blur)*edge; 
        float frontMask = Heart(info.uv1, blur)*edge; 
        float frontLight = sat(dot(LIGHT_DIR, info.n1)*.8+.2);
        float backLight = sat(dot(LIGHT_DIR, info.n2)*.8+.2)*.9;

        col = mix(vec4(backLight*HEARTCOL, backMask), 
                  vec4(frontLight*HEARTCOL, frontMask), 
                  frontMask);
    }
    return col;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = (fragCoord.xy-.5*iResolution.xy) / iResolution.y;
    vec2 m = iMouse.xy/iResolution.xy;
    float t = iTime*.3;
  
    vec3 rd = normalize(vec3(uv, 1));
    
    m.y = iMouse.z>0. ? 1.-m.y : .4;

    vec2 rot = t*vec2(.12, .18);
    vec4 col = vec4(0);
        
    for(float i=0.; i<1.; i+=(1./NUM_HEARTS)) {
        float x = (fract(cos(i*536.3)*7464.4)-.5)*15.;
        float y = (fract(-t*.2+i*7.64)-.5)*15.;
        float z = mix(14., 2., i);
        
        float blur = mix(.03, .35, S(.0, .4, abs(m.y-i)));
        
        rot += (fract(sin(i*vec2(536.3, 23.4))*vec2(764.4, 987.3))-.5);
        vec4 heart = HeartBall(rd, vec3(x, y, z), rot, t, blur);
        
        col = mix(col, heart, heart.a);
    }
	
    fragColor = col;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

